/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterjungletemples.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterjungletemples.mixin.accessor.ChunkGeneratorStructureStateAccessor;
import com.yungnickyoung.minecraft.betterjungletemples.module.StructurePlacementTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.structure.exclusion.EnhancedExclusionZone;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_5699;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_6908;
import net.minecraft.class_7138;
import net.minecraft.class_7869;

public class BetterJungleTemplePlacement
extends class_6872 {
    public static final Codec<BetterJungleTemplePlacement> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2382.method_39677((int)16).optionalFieldOf("locate_offset", (Object)class_2382.field_11176).forGetter(placement -> placement.method_41642()), (App)class_6874.class_7154.field_37786.optionalFieldOf("frequency_reduction_method", (Object)class_6874.class_7154.field_37782).forGetter(placement -> placement.method_41643()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(placement -> Float.valueOf(placement.method_41644())), (App)class_5699.field_33441.fieldOf("salt").forGetter(placement -> placement.method_41645()), (App)class_6874.class_7152.field_37781.optionalFieldOf("exclusion_zone").forGetter(placement -> placement.method_41646()), (App)EnhancedExclusionZone.CODEC.optionalFieldOf("enhanced_exclusion_zone").forGetter(placement -> placement.enhancedExclusionZone), (App)class_5699.field_33441.fieldOf("spacing").forGetter(placement -> placement.method_41632()), (App)class_5699.field_33441.fieldOf("separation").forGetter(placement -> placement.method_41633()), (App)class_6873.field_36423.optionalFieldOf("spread_type", (Object)class_6873.field_36421).forGetter(placement -> placement.method_41634())).apply((Applicative)builder, builder.stable(BetterJungleTemplePlacement::new))).flatXmap(BetterJungleTemplePlacement.verifySpacing(), DataResult::success).codec();
    private final Optional<EnhancedExclusionZone> enhancedExclusionZone;

    private static Function<BetterJungleTemplePlacement, DataResult<BetterJungleTemplePlacement>> verifySpacing() {
        return placement -> placement.method_41632() <= placement.method_41633() ? DataResult.error(() -> "EnhancedRandomSpread's spacing has to be larger than separation") : DataResult.success((Object)placement);
    }

    public BetterJungleTemplePlacement(class_2382 locateOffset, class_6874.class_7154 frequencyReductionMethod, Float frequency, Integer salt, Optional<class_6874.class_7152> exclusionZone, Optional<EnhancedExclusionZone> enhancedExclusionZone, Integer spacing, Integer separation, class_6873 randomSpreadType) {
        super(locateOffset, frequencyReductionMethod, frequency.floatValue(), salt.intValue(), exclusionZone, spacing.intValue(), separation.intValue(), randomSpreadType);
        this.enhancedExclusionZone = enhancedExclusionZone;
    }

    public class_6875<?> method_40166() {
        return StructurePlacementTypeModule.BETTER_JUNGLE_TEMPLE_PLACEMENT;
    }

    protected boolean method_40168(class_7869 state, int chunkX, int chunkZ) {
        class_1966 biomeSource = ((ChunkGeneratorStructureStateAccessor)state).getBiomeSource();
        class_7138 randomState = state.method_46713();
        long seed = state.method_46714();
        class_1923 chunkPos = this.method_40169(seed, chunkX, chunkZ);
        if (chunkPos.field_9181 == chunkX && chunkPos.field_9180 == chunkZ) {
            class_2338 structurePos = chunkPos.method_33943(120);
            boolean isOceanOrRiverNear = biomeSource.method_24385(structurePos.method_10263(), structurePos.method_10264(), structurePos.method_10260(), 48, 2, biomeHolder -> biomeHolder.method_40220(class_6908.field_36511) || biomeHolder.method_40220(class_6908.field_36509), randomState.method_42374().method_38419(structurePos), true, randomState.method_42371()) != null;
            return !isOceanOrRiverNear;
        }
        return false;
    }

    public boolean method_41639(class_7869 state, int x, int z) {
        if (!super.method_41639(state, x, z)) {
            return false;
        }
        return this.enhancedExclusionZone.isEmpty() || !this.enhancedExclusionZone.get().isPlacementForbidden(state, x, z);
    }
}

